/*
 * Decompiled with CFR 0.152.
 */
package com.johnymuffin.jperms.beta;

import com.johnymuffin.jperms.beta.JohnyPermsAPI;
import com.johnymuffin.jperms.beta.JohnyPermsCommand;
import com.johnymuffin.jperms.beta.JohnyPermsListener;
import com.johnymuffin.jperms.beta.config.JPConfig;
import com.johnymuffin.jperms.beta.config.JPUUIDCache;
import com.johnymuffin.jperms.beta.config.JPermsLanguage;
import com.johnymuffin.jperms.beta.config.PermissionsConfig;
import com.johnymuffin.jperms.beta.importer.PexImport;
import com.johnymuffin.jperms.beta.objects.Group;
import com.johnymuffin.jperms.beta.override.JPPermissibleBase;
import com.johnymuffin.jperms.beta.util.Util;
import com.johnymuffin.jperms.core.models.PermissionsGroup;
import com.johnymuffin.jperms.core.models.PermissionsObject;
import com.johnymuffin.jperms.core.models.PermissionsUser;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;

public class JohnyPerms
extends JavaPlugin {
    private static JohnyPerms plugin;
    private Logger log;
    private String pluginName;
    private PluginDescriptionFile pdf;
    private int debugLevel = 3;
    private JPermsLanguage language;
    private PermissionsGroup defaultGroup;
    private HashMap<String, PermissionsGroup> groups = new HashMap();
    private HashMap<UUID, PermissionsUser> users = new HashMap();
    private HashMap<UUID, PermissionAttachment> attachments = new HashMap();
    private PermissionsConfig permissionsConfig;
    private HashMap<String, Boolean> allPluginPerms = new HashMap();
    private HashMap<String, Boolean> detectedPerms = new HashMap();
    private JohnyPermsAPI johnyPermsAPI;
    private HashMap<UUID, JPPermissibleBase> playerInjections = new HashMap();
    private JPUUIDCache jpuuidCache;
    private JPConfig config;

    public void onEnable() {
        plugin = this;
        this.log = this.getServer().getLogger();
        this.pdf = this.getDescription();
        this.jpuuidCache = new JPUUIDCache(plugin);
        this.pluginName = this.pdf.getName();
        this.log.info("[" + this.pluginName + "] Is Loading, Version: " + this.pdf.getVersion());
        this.log.info("[" + this.pluginName + "] Loading Language File.");
        this.language = new JPermsLanguage(new File(plugin.getDataFolder(), "language.yml"));
        this.log.info("[" + this.pluginName + "] Loading plugin settings.");
        this.config = new JPConfig(new File(plugin.getDataFolder(), "config.yml"));
        if (this.config.isNew()) {
            this.logMessage(Level.INFO, "JohnyPerms has started for the first time. Please set your config appropriately and then proceed.");
            Bukkit.shutdown();
            this.config = new JPConfig(new File(plugin.getDataFolder(), "config.yml"));
        }
        this.log.info("[" + this.pluginName + "] Loading Permissions Database.");
        try {
            this.permissionsConfig = new PermissionsConfig(plugin);
        }
        catch (ParseException e) {
            this.log.log(Level.SEVERE, "Failed to load permissions file", e);
            Bukkit.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (this.permissionsConfig.isNew()) {
            this.log.info("[" + this.pluginName + "] Generating default group as it is first load.");
            String[] group = new Group(plugin, "default", new JSONObject());
            group.setIsDefaultGroup(true);
            group.setSaveStatus(true);
            this.groups.put("default", (PermissionsGroup)group);
        }
        this.calculateAllPermissions();
        this.log.info("[" + this.pluginName + "] Registering Commands.");
        plugin.getCommand("jperms").setExecutor((CommandExecutor)new JohnyPermsCommand(plugin));
        this.log.info("[" + this.pluginName + "] Loading Groups.");
        for (String groupName : this.permissionsConfig.getGroupNames()) {
            PermissionsGroup group = this.permissionsConfig.getGroup(groupName);
            if (group == null) {
                this.log.info("[" + this.pluginName + "] group " + groupName + " failed to load, shutting down.");
                Bukkit.getServer().getPluginManager().disablePlugin((Plugin)this);
                return;
            }
            this.groups.put(groupName, group);
            this.log.info("[" + this.pluginName + "] Loaded group " + groupName);
        }
        this.scanForDefault();
        if (this.defaultGroup == null) {
            this.log.info("[" + this.pluginName + "] Failed to find a default group, shutting down.");
            Bukkit.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.log.info("[" + this.pluginName + "] Default group set to: " + this.defaultGroup.getName());
        this.verifyInheritance();
        this.log.info("[" + this.pluginName + "] Starting player listener.");
        JohnyPermsListener johnyPermsListener = new JohnyPermsListener(plugin);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)johnyPermsListener, (Plugin)plugin);
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            this.recalculatePlayer(p);
        }
        this.johnyPermsAPI = new JohnyPermsAPI(plugin);
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, () -> {
            this.calculateAllPermissions();
            if (this.config.getConfigBoolean("import.permissionsex").booleanValue() && Bukkit.getServer().getPluginManager().isPluginEnabled("PermissionsEx")) {
                plugin.logMessage(Level.INFO, "Importing PermissionsEX");
                PexImport pexImport = new PexImport(plugin);
                this.getGroups().remove("default");
                pexImport.importGroups();
                this.scanForDefault();
                try {
                    pexImport.importPlayers();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                plugin.logMessage(Level.INFO, "Finished importing PermissionsEx");
                this.verifyInheritance();
                this.config.setProperty("import.permissionsex", false);
                this.config.save();
            }
        }, 0L);
    }

    public void verifyInheritance() {
        for (String group : this.groups.keySet()) {
            this.groups.get(group).getInheritanceGroups();
        }
    }

    public boolean reloadStorage() {
        this.groups = new HashMap();
        this.users = new HashMap();
        this.allPluginPerms = new HashMap();
        this.detectedPerms = new HashMap();
        this.log.info("[" + this.pluginName + "] Loading Language File.");
        this.language = new JPermsLanguage(new File(plugin.getDataFolder(), "language.yml"));
        this.log.info("[" + this.pluginName + "] Loading plugin settings.");
        this.config = new JPConfig(new File(plugin.getDataFolder(), "config.yml"));
        if (this.config.isNew()) {
            this.logMessage(Level.INFO, "JohnyPerms has started for the first time. Please set your config appropriately and then proceed.");
            Bukkit.shutdown();
            this.config = new JPConfig(new File(plugin.getDataFolder(), "config.yml"));
        }
        this.log.info("[" + this.pluginName + "] Loading Permissions Database.");
        try {
            this.permissionsConfig = new PermissionsConfig(plugin);
        }
        catch (ParseException e) {
            this.log.log(Level.SEVERE, "Failed to load permissions file", e);
            Bukkit.getServer().getPluginManager().disablePlugin((Plugin)this);
            return false;
        }
        if (this.permissionsConfig.isNew()) {
            this.log.info("[" + this.pluginName + "] Generating default group as it is first load.");
            Group group = new Group(plugin, "default", new JSONObject());
            group.setIsDefaultGroup(true);
            group.setSaveStatus(true);
            this.groups.put("default", group);
        }
        this.calculateAllPermissions();
        this.log.info("[" + this.pluginName + "] Loading Groups.");
        for (String groupName : this.permissionsConfig.getGroupNames()) {
            PermissionsGroup group = this.permissionsConfig.getGroup(groupName);
            if (group == null) {
                this.log.info("[" + this.pluginName + "] group " + groupName + " failed to load, shutting down.");
                Bukkit.getServer().getPluginManager().disablePlugin((Plugin)this);
                return false;
            }
            this.groups.put(groupName, group);
            this.log.info("[" + this.pluginName + "] Loaded group " + groupName);
        }
        this.scanForDefault();
        if (this.defaultGroup == null) {
            this.log.info("[" + this.pluginName + "] Failed to find a default group, shutting down.");
            Bukkit.getServer().getPluginManager().disablePlugin((Plugin)this);
            return false;
        }
        this.log.info("[" + this.pluginName + "] Default group set to: " + this.defaultGroup.getName());
        this.verifyInheritance();
        this.recalculateAllPlayers();
        return true;
    }

    public void recalculateAllPlayers() {
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            this.recalculatePlayer(p);
        }
    }

    public void calculateAllPermissions() {
        this.log.info("[" + this.pluginName + "] Loading all permissions for wildcards.");
        this.allPluginPerms = new HashMap();
        for (Plugin plugin : Bukkit.getServer().getPluginManager().getPlugins()) {
            for (Permission permission : plugin.getDescription().getPermissions()) {
                this.allPluginPerms.put(permission.getName(), true);
                for (Map.Entry entry : permission.getChildren().entrySet()) {
                    this.allPluginPerms.put((String)entry.getKey(), (Boolean)entry.getValue());
                }
            }
        }
    }

    public JPUUIDCache getJpuuidCache() {
        return this.jpuuidCache;
    }

    public void removeDuplicatePermissions(PermissionsGroup group, boolean log) {
        HashMap<String, Boolean> mainGroupPerms = group.getPermissions(false);
        Object[] rawPerms = mainGroupPerms.keySet().toArray();
        for (int i = 0; i < mainGroupPerms.size(); ++i) {
            HashMap mainGroupPermsTemp = (HashMap)mainGroupPerms.clone();
            mainGroupPermsTemp.remove(rawPerms[i]);
            if (!Util.hasPermissionOnMap((String)rawPerms[i], mainGroupPermsTemp).booleanValue() || !group.removePermission((String)rawPerms[i])) continue;
            this.logMessage(Level.INFO, "Removing permission " + rawPerms[i] + " as the group " + group.getName() + " already has the permission most likely through a wildcard.");
        }
        for (PermissionsGroup inheritanceGroup : group.getInheritanceGroups()) {
            for (Map.Entry<String, Boolean> permission : inheritanceGroup.getPermissions(true).entrySet()) {
                if (!permission.getValue().booleanValue() || !group.hasPermission(permission.getKey(), false) || !group.removePermission(permission.getKey())) continue;
                this.logMessage(Level.INFO, "Permission: " + permission.getKey() + " removed from group " + group.getName() + " as the group inherits it from " + inheritanceGroup.getName());
            }
        }
    }

    public void save(boolean users, boolean groups, boolean settings) {
        if (users) {
            for (Map.Entry<Object, PermissionsObject> entry : this.users.entrySet()) {
                if (!((PermissionsUser)entry.getValue()).isSaving()) continue;
                this.permissionsConfig.saveUser((PermissionsUser)entry.getValue());
                this.log.info("[" + this.pluginName + "] Saved user: " + entry.getKey());
            }
        }
        if (groups) {
            for (Map.Entry<Object, PermissionsObject> entry : this.groups.entrySet()) {
                if (!((PermissionsGroup)entry.getValue()).isSaving()) continue;
                this.permissionsConfig.saveGroup((PermissionsGroup)entry.getValue());
                this.log.info("[" + this.pluginName + "] Saved group called: " + (String)entry.getKey());
            }
        }
        if (settings) {
            this.jpuuidCache.saveData();
        }
    }

    public void onDisable() {
        this.log.info("[" + this.pluginName + "] Plugin disabling.");
        this.johnyPermsAPI = null;
        this.save(true, true, true);
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            this.removePlayer(p);
        }
        this.log.info("[" + this.pluginName + "] Plugin disabled.");
    }

    public void scanForDefault() {
        for (String group : this.getGroups().keySet()) {
            if (!this.groups.get(group).isDefaultGroup()) continue;
            this.defaultGroup = this.groups.get(group);
        }
    }

    public void logMessage(Level level, String msg) {
        this.log.log(level, "[" + this.pluginName + "] " + msg);
    }

    public PermissionsUser getUser(UUID uuid) {
        if (this.users.containsKey(uuid)) {
            return this.users.get(uuid);
        }
        PermissionsUser user = this.permissionsConfig.getUser(uuid);
        this.users.put(uuid, user);
        return user;
    }

    public HashMap<String, PermissionsGroup> getGroups() {
        return this.groups;
    }

    public HashMap<UUID, PermissionsUser> getUsers() {
        return this.users;
    }

    public PermissionsGroup getDefaultGroup() {
        return this.defaultGroup;
    }

    public HashMap<UUID, PermissionAttachment> getAttachments() {
        return this.attachments;
    }

    public JPermsLanguage getLanguage() {
        return this.language;
    }

    public PermissionsConfig getPermissionsConfig() {
        return this.permissionsConfig;
    }

    public HashMap<String, Boolean> getAllPluginPerms() {
        return this.allPluginPerms;
    }

    public void recalculatePlayer(Player p) {
        if (plugin.getAttachments().containsKey(p.getUniqueId())) {
            try {
                p.removeAttachment(plugin.getAttachments().get(p.getUniqueId()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            plugin.getAttachments().remove(p.getUniqueId());
        }
        PermissionAttachment attachment = p.addAttachment((Plugin)plugin);
        plugin.getAttachments().put(p.getUniqueId(), attachment);
        for (String string : attachment.getPermissions().keySet()) {
            attachment.unsetPermission(string);
        }
        for (Map.Entry entry : plugin.getUser(p.getUniqueId()).getPermissions().entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            attachment.setPermission((String)entry.getKey(), ((Boolean)entry.getValue()).booleanValue());
        }
        p.recalculatePermissions();
    }

    public void removePlayer(Player player) {
        if (plugin.getAttachments().containsKey(player.getUniqueId())) {
            try {
                player.removeAttachment(plugin.getAttachments().get(player.getUniqueId()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            plugin.getAttachments().remove(player.getUniqueId());
        }
    }

    public static JohnyPermsAPI getJPermsAPI() {
        Plugin plugin = Bukkit.getServer().getPluginManager().getPlugin("JPerms");
        if (plugin == null || !(plugin instanceof JohnyPerms) || !plugin.isEnabled()) {
            throw new RuntimeException("JohnyPerms API isn't valid, is the plugin actually started?");
        }
        return ((JohnyPerms)plugin).johnyPermsAPI;
    }

    public HashMap<UUID, JPPermissibleBase> getPlayerInjections() {
        return this.playerInjections;
    }

    public JPConfig getConfig() {
        return this.config;
    }
}

