/*
 * Decompiled with CFR 0.152.
 */
package com.johnymuffin.jperms.beta;

import com.johnymuffin.jperms.beta.JohnyPerms;
import com.johnymuffin.jperms.beta.config.JPermsLanguage;
import com.johnymuffin.jperms.beta.util.Util;
import com.johnymuffin.jperms.core.models.PermissionsGroup;
import com.johnymuffin.jperms.core.models.PermissionsUser;
import java.util.Map;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class JohnyPermsCommand
implements CommandExecutor {
    private JohnyPerms plugin;
    private JPermsLanguage lang;

    public JohnyPermsCommand(JohnyPerms plugin) {
        this.plugin = plugin;
        this.lang = plugin.getLanguage();
    }

    public boolean onCommand(CommandSender commandSender, Command command, String s, String[] strings) {
        if (!this.isAuthorized(commandSender, "johnyperms.jperms.command")) {
            commandSender.sendMessage(this.lang.getMessage("no_permission"));
            return true;
        }
        if (strings.length > 0) {
            String subcommand = strings[0];
            if (subcommand.equalsIgnoreCase("user")) {
                return this.userCommand(commandSender, command, s, strings);
            }
            if (subcommand.equalsIgnoreCase("group")) {
                return this.groupCommand(commandSender, command, s, strings);
            }
            if (subcommand.equalsIgnoreCase("plugin")) {
                return this.pluginCommand(commandSender, command, s, strings);
            }
        }
        commandSender.sendMessage(this.lang.getMessage("jperms_main_general_use"));
        return true;
    }

    private boolean userCommand(CommandSender commandSender, Command command, String s, String[] strings) {
        if (!this.isAuthorized(commandSender, "johnyperms.jperms.user")) {
            commandSender.sendMessage(this.lang.getMessage("no_permission"));
            return true;
        }
        String rawPlayerName = null;
        UUID uuid = null;
        if (strings.length >= 2) {
            rawPlayerName = strings[1];
            uuid = Util.getUUIDFromUsername(rawPlayerName);
            if (uuid == null) {
                uuid = this.plugin.getJpuuidCache().getUUIDFromUsername(rawPlayerName);
            }
            if (uuid == null) {
                String message = this.lang.getMessage("player_not_found_full");
                message = message.replace("%username%", rawPlayerName);
                commandSender.sendMessage(message);
                return true;
            }
        }
        if (strings.length == 2) {
            commandSender.sendMessage(ChatColor.BLUE + "Information on " + ChatColor.GOLD + uuid.toString());
            PermissionsUser permissionsUser = this.plugin.getUser(uuid);
            commandSender.sendMessage(ChatColor.BLUE + "Group: " + ChatColor.GOLD + permissionsUser.getGroup().getName());
            commandSender.sendMessage(ChatColor.BLUE + "Save Status: " + ChatColor.GOLD + permissionsUser.isSaving());
            return true;
        }
        if (strings.length >= 3) {
            String subCommand = strings[2];
            if (subCommand.equalsIgnoreCase("perm")) {
                return this.userPermCommand(commandSender, command, s, strings, uuid);
            }
            if (subCommand.equalsIgnoreCase("group")) {
                return this.userGroupCommand(commandSender, command, s, strings, uuid);
            }
        }
        commandSender.sendMessage(this.lang.getMessage("jperms_user_general_use"));
        return true;
    }

    private boolean userPermCommand(CommandSender commandSender, Command command, String s, String[] strings, UUID user) {
        if (!this.isAuthorized(commandSender, "johnyperms.jperms.user.perm")) {
            commandSender.sendMessage(this.lang.getMessage("no_permission"));
            return true;
        }
        if (strings.length >= 4) {
            String subCommand = strings[3];
            if (subCommand.equalsIgnoreCase("add")) {
                return this.userPermAddCommand(commandSender, command, s, strings, user);
            }
            if (subCommand.equalsIgnoreCase("list")) {
                return this.userPermListCommand(commandSender, command, s, strings, user);
            }
            if (subCommand.equalsIgnoreCase("remove")) {
                return this.userPermRemoveCommand(commandSender, command, s, strings, user);
            }
        }
        commandSender.sendMessage(this.lang.getMessage("jperms_user_perm_use"));
        return true;
    }

    private boolean userPermListCommand(CommandSender commandSender, Command command, String s, String[] strings, UUID user) {
        if (!this.isAuthorized(commandSender, "johnyperms.jperms.user.perm.list")) {
            commandSender.sendMessage(this.lang.getMessage("no_permission"));
            return true;
        }
        PermissionsUser permissionsUser = this.plugin.getUser(user);
        commandSender.sendMessage(ChatColor.GOLD + "User Specific Perms: ");
        for (Map.Entry<String, Boolean> permission : permissionsUser.getPermissions(false).entrySet()) {
            if (permission.getValue().booleanValue()) {
                commandSender.sendMessage(ChatColor.GOLD + permission.getKey());
                continue;
            }
            commandSender.sendMessage(ChatColor.GOLD + "-" + permission.getKey());
        }
        return true;
    }

    private boolean userPermAddCommand(CommandSender commandSender, Command command, String s, String[] strings, UUID user) {
        if (!this.isAuthorized(commandSender, "johnyperms.jperms.user.perm.add")) {
            commandSender.sendMessage(this.lang.getMessage("no_permission"));
            return true;
        }
        if (strings.length >= 5) {
            String permission = strings[4];
            PermissionsUser permissionsUser = this.plugin.getUser(user);
            permissionsUser.addPermission(permission);
            commandSender.sendMessage(this.lang.getMessage("generic_action_completed"));
            return true;
        }
        this.plugin.recalculateAllPlayers();
        commandSender.sendMessage(this.lang.getMessage("jperms_user_perm_add_use"));
        return true;
    }

    private boolean userPermRemoveCommand(CommandSender commandSender, Command command, String s, String[] strings, UUID user) {
        if (!this.isAuthorized(commandSender, "johnyperms.jperms.user.perm.remove")) {
            commandSender.sendMessage(this.lang.getMessage("no_permission"));
            return true;
        }
        if (strings.length >= 5) {
            String permission = strings[4];
            PermissionsUser permissionsUser = this.plugin.getUser(user);
            permissionsUser.removePermission(permission);
            commandSender.sendMessage(this.lang.getMessage("generic_action_completed"));
            return true;
        }
        this.plugin.recalculateAllPlayers();
        commandSender.sendMessage(this.lang.getMessage("jperms_user_perm_remove_use"));
        return false;
    }

    private boolean userGroupCommand(CommandSender commandSender, Command command, String s, String[] strings, UUID user) {
        if (!this.isAuthorized(commandSender, "johnyperms.jperms.user.group")) {
            commandSender.sendMessage(this.lang.getMessage("no_permission"));
            return true;
        }
        if (strings.length == 3 || strings.length == 4 || !strings[3].equalsIgnoreCase("set")) {
            commandSender.sendMessage(this.lang.getMessage("jperms_user_group_general_use"));
            commandSender.sendMessage(ChatColor.GRAY + "Group: " + this.plugin.getUser(user).getGroup().getName());
            return true;
        }
        PermissionsGroup permissionsGroup = this.plugin.getGroups().get(strings[4].toLowerCase());
        if (permissionsGroup == null) {
            commandSender.sendMessage(this.lang.getMessage("jperms_group_general_unknown"));
            return true;
        }
        this.plugin.getUser(user).setGroup(permissionsGroup);
        commandSender.sendMessage(this.lang.getMessage("generic_action_completed"));
        this.plugin.recalculateAllPlayers();
        return true;
    }

    private boolean groupCommand(CommandSender commandSender, Command command, String s, String[] strings) {
        if (!this.isAuthorized(commandSender, "johnyperms.jperms.group")) {
            commandSender.sendMessage(this.lang.getMessage("no_permission"));
            return true;
        }
        if (strings.length == 1) {
            commandSender.sendMessage(this.lang.getMessage("jperms_group_general_use"));
            return true;
        }
        PermissionsGroup permissionsGroup = null;
        if (strings.length > 1 && (permissionsGroup = this.plugin.getGroups().get(strings[1])) == null) {
            commandSender.sendMessage(this.lang.getMessage("jperms_group_general_unknown"));
            return true;
        }
        if (strings.length == 2) {
            commandSender.sendMessage(ChatColor.BLUE + "Selected Group: " + permissionsGroup.getName());
            return true;
        }
        String subCommand = strings[2];
        if (subCommand.equalsIgnoreCase("inheritance")) {
            return this.groupInheritanceCommand(commandSender, command, s, strings, permissionsGroup);
        }
        commandSender.sendMessage(this.lang.getMessage("jperms_group_general_use"));
        return true;
    }

    private boolean groupInheritanceCommand(CommandSender commandSender, Command command, String s, String[] strings, PermissionsGroup group) {
        if (!this.isAuthorized(commandSender, "johnyperms.jperms.group.inheritance")) {
            commandSender.sendMessage(this.lang.getMessage("no_permission"));
            return true;
        }
        commandSender.sendMessage(ChatColor.GRAY + "Inheritance for: " + group.getName());
        for (int i = 0; i < group.getInheritanceGroups().length; ++i) {
            commandSender.sendMessage(ChatColor.GRAY + String.valueOf(i + 1) + " " + ChatColor.BLUE + group.getInheritanceGroups()[i].getName());
        }
        return true;
    }

    private boolean pluginCommand(CommandSender commandSender, Command command, String s, String[] strings) {
        if (!this.isAuthorized(commandSender, "johnyperms.jperms.plugin")) {
            commandSender.sendMessage(this.lang.getMessage("no_permission"));
            return true;
        }
        if (strings.length > 1) {
            String subcommand = strings[1];
            if (subcommand.equalsIgnoreCase("reload")) {
                return this.pluginReloadCommand(commandSender, command, s, strings);
            }
            if (subcommand.equalsIgnoreCase("save")) {
                return this.pluginSaveCommand(commandSender, command, s, strings);
            }
        }
        commandSender.sendMessage(this.lang.getMessage("jperms_plugin_use"));
        return true;
    }

    private boolean pluginReloadCommand(CommandSender commandSender, Command command, String s, String[] strings) {
        if (!this.isAuthorized(commandSender, "johnyperms.jperms.plugin.reload")) {
            commandSender.sendMessage(this.lang.getMessage("no_permission"));
            return true;
        }
        long unixStart = System.currentTimeMillis();
        if (!this.plugin.reloadStorage()) {
            commandSender.sendMessage(ChatColor.RED + "A severe error occurred while reloading, and JPerms is shutting down immediately. Please check console for details.");
            return true;
        }
        long timeTaken = System.currentTimeMillis() - unixStart;
        commandSender.sendMessage(ChatColor.RED + "Reload completed in " + timeTaken + " milliseconds.");
        return true;
    }

    private boolean pluginSaveCommand(CommandSender commandSender, Command command, String s, String[] strings) {
        if (!this.isAuthorized(commandSender, "johnyperms.jperms.plugin.save")) {
            commandSender.sendMessage(this.lang.getMessage("no_permission"));
            return true;
        }
        long unixStart = System.currentTimeMillis();
        this.plugin.save(true, true, true);
        long timeTaken = System.currentTimeMillis() - unixStart;
        commandSender.sendMessage(ChatColor.RED + "Save completed in " + timeTaken + " milliseconds.");
        return true;
    }

    private boolean isAuthorized(CommandSender commandSender, String permission) {
        return commandSender.isOp() || commandSender.hasPermission(permission);
    }
}

