/*
 * Decompiled with CFR 0.152.
 */
package com.johnymuffin.jperms.beta;

import com.johnymuffin.jperms.beta.JohnyPerms;
import com.johnymuffin.jperms.beta.override.JPInject;
import com.johnymuffin.jperms.beta.override.JPPermissibleBase;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.ServerOperator;

public class JohnyPermsListener
implements Listener {
    private JohnyPerms plugin;

    public JohnyPermsListener(JohnyPerms plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=Event.Priority.Lowest)
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        this.plugin.recalculatePlayer(event.getPlayer());
        this.plugin.getJpuuidCache().addUser(event.getPlayer().getName(), event.getPlayer().getUniqueId());
        this.plugin.getUser(event.getPlayer().getUniqueId()).setLastKnownUsername(event.getPlayer().getName());
        if (this.plugin.getConfig().getConfigBoolean("super-perms-override.enable").booleanValue()) {
            JPPermissibleBase jpPermissibleBase = new JPPermissibleBase(event.getPlayer(), (ServerOperator)event.getPlayer());
            JPInject.inject((CommandSender)event.getPlayer(), (Permissible)jpPermissibleBase);
            this.plugin.getPlayerInjections().put(event.getPlayer().getUniqueId(), jpPermissibleBase);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.playerLeave(event.getPlayer());
    }

    @EventHandler
    public void onPlayerKick(PlayerKickEvent event) {
        this.playerLeave(event.getPlayer());
    }

    public void playerLeave(Player player) {
        this.plugin.getPlayerInjections().remove(player.getUniqueId());
        this.plugin.removePlayer(player);
    }
}

