/*
 * Decompiled with CFR 0.152.
 */
package com.johnymuffin.jperms.beta.config;

import java.io.File;
import org.bukkit.util.config.Configuration;

public class JPConfig
extends Configuration {
    private boolean isNew = true;

    public JPConfig(File file) {
        super(file);
        this.isNew = !file.exists();
        this.reload();
    }

    public void reload() {
        this.load();
        this.write();
        this.save();
    }

    private void write() {
        this.generateConfigOption("super-perms-override.enable", false);
        this.generateConfigOption("import.permissionsex", true);
    }

    private void generateConfigOption(String key, Object defaultValue) {
        if (this.getProperty(key) == null) {
            this.setProperty(key, defaultValue);
        }
        Object value = this.getProperty(key);
        this.removeProperty(key);
        this.setProperty(key, value);
    }

    public Object getConfigOption(String key) {
        return this.getProperty(key);
    }

    public Object getConfigOption(String key, Object defaultValue) {
        Object value = this.getConfigOption(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public String getConfigString(String key) {
        return String.valueOf(this.getConfigOption(key));
    }

    public Integer getConfigInteger(String key) {
        return Integer.valueOf(this.getConfigString(key));
    }

    public Long getConfigLong(String key) {
        return Long.valueOf(this.getConfigString(key));
    }

    public Double getConfigDouble(String key) {
        return Double.valueOf(this.getConfigString(key));
    }

    public Boolean getConfigBoolean(String key) {
        return Boolean.valueOf(this.getConfigString(key));
    }

    private synchronized void convertToNewConfig() {
    }

    private boolean convertToNewAddress(String newKey, String oldKey) {
        if (this.getString(newKey) != null) {
            return false;
        }
        if (this.getString(oldKey) == null) {
            return false;
        }
        System.out.println("Converting Config: " + oldKey + " to " + newKey);
        Object value = this.getProperty(oldKey);
        this.setProperty(newKey, value);
        this.removeProperty(oldKey);
        return true;
    }

    public boolean isNew() {
        return this.isNew;
    }
}

