/*
 * Decompiled with CFR 0.152.
 */
package com.johnymuffin.jperms.beta.config;

import com.johnymuffin.jperms.beta.JohnyPerms;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.UUID;
import java.util.logging.Level;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JPUUIDCache {
    private JohnyPerms plugin;
    private JSONObject usernameUUIDCache;
    private File cacheFile;
    private boolean memoryOnly = false;

    public JPUUIDCache(JohnyPerms plugin) {
        this.plugin = plugin;
        this.cacheFile = new File(plugin.getDataFolder(), "UUIDCache.json");
        if (!this.cacheFile.exists()) {
            this.cacheFile.getParentFile().mkdirs();
            try {
                FileWriter file = new FileWriter(this.cacheFile);
                plugin.logMessage(Level.INFO, "Generating UUIDCache.json file");
                this.usernameUUIDCache = new JSONObject();
                file.write(this.usernameUUIDCache.toJSONString());
                file.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            plugin.logMessage(Level.INFO, "Reading UUIDCache.json file");
            JSONParser parser = new JSONParser();
            this.usernameUUIDCache = (JSONObject)parser.parse((Reader)new FileReader(this.cacheFile));
        }
        catch (ParseException e) {
            plugin.logMessage(Level.WARNING, "UUIDCache.json file is corrupt, resetting file: " + (Object)((Object)e) + " : " + e.getMessage());
            this.usernameUUIDCache = new JSONObject();
        }
        catch (Exception e) {
            plugin.logMessage(Level.WARNING, "UUIDCache.json file is corrupt, changing to memory only mode.");
            this.memoryOnly = true;
            this.usernameUUIDCache = new JSONObject();
        }
    }

    public void addUser(String username, UUID uuid) {
        this.usernameUUIDCache.put((Object)username.toLowerCase(), (Object)uuid.toString());
    }

    public UUID getUUIDFromUsername(String username) {
        if (this.usernameUUIDCache.containsKey((Object)(username = username.toLowerCase()))) {
            return UUID.fromString(String.valueOf(this.usernameUUIDCache.get((Object)username)));
        }
        return null;
    }

    public void saveData() {
        this.saveJsonArray();
    }

    private void saveJsonArray() {
        if (this.memoryOnly) {
            return;
        }
        try (FileWriter file = new FileWriter(this.cacheFile);){
            this.plugin.logMessage(Level.INFO, "Saving UUIDCache.json");
            file.write(this.usernameUUIDCache.toJSONString());
            file.flush();
        }
        catch (IOException e) {
            this.plugin.logMessage(Level.WARNING, "Error saving UUIDCache.json: " + e + " : " + e.getMessage());
        }
    }
}

