/*
 * Decompiled with CFR 0.152.
 */
package com.johnymuffin.jperms.beta.config;

import com.johnymuffin.jperms.beta.JohnyPerms;
import com.johnymuffin.jperms.beta.objects.Group;
import com.johnymuffin.jperms.beta.objects.User;
import com.johnymuffin.jperms.core.models.PermissionsGroup;
import com.johnymuffin.jperms.core.models.PermissionsUser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.UUID;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class PermissionsConfig {
    protected File configFile;
    protected JSONObject jsonConfig;
    private JohnyPerms plugin;
    private boolean isNew = false;

    public PermissionsConfig(JohnyPerms plugin) throws ParseException {
        this.configFile = new File(plugin.getDataFolder(), "permissions.json");
        this.plugin = plugin;
        if (!this.configFile.exists()) {
            this.isNew = true;
            this.configFile.getParentFile().mkdirs();
            this.jsonConfig = new JSONObject();
            this.saveFile();
        } else {
            try {
                JSONParser parser = new JSONParser();
                this.jsonConfig = (JSONObject)parser.parse((Reader)new FileReader(this.configFile));
            }
            catch (IOException e) {
                throw new RuntimeException(e + ": " + e.getMessage());
            }
        }
        this.saveFile();
    }

    public PermissionsUser getUser(UUID uuid) {
        JSONObject tmp = this.getPlayers();
        if (tmp.containsKey((Object)String.valueOf(uuid))) {
            try {
                User user = new User(this.plugin, (JSONObject)tmp.get((Object)String.valueOf(uuid)), uuid, false);
                return user;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new User(this.plugin, uuid);
    }

    public void saveUser(PermissionsUser permissionsUser) {
        JSONObject tmp = new JSONObject();
        JSONArray tmp2 = new JSONArray();
        tmp.put((Object)"group", (Object)permissionsUser.getGroup().getName());
        for (Map.Entry<String, Boolean> entry : permissionsUser.getPermissions(false).entrySet()) {
            if (entry.getValue().booleanValue()) {
                tmp2.add((Object)entry.getKey());
                continue;
            }
            tmp2.add((Object)("-" + entry.getKey()));
        }
        tmp.put((Object)"permissions", (Object)tmp2);
        if (permissionsUser.getPrefix() != null && !permissionsUser.getPrefix().isEmpty()) {
            tmp.put((Object)"prefix", (Object)permissionsUser.getPrefix());
        }
        if (permissionsUser.getLastKnownUsername() != null) {
            tmp.put((Object)"lastKnownUsername", (Object)permissionsUser.getLastKnownUsername());
        }
        if (permissionsUser.getSuffix() != null && !permissionsUser.getSuffix().isEmpty()) {
            tmp.put((Object)"suffix", (Object)permissionsUser.getSuffix());
        }
        JSONObject tmp3 = this.getPlayers();
        tmp3.put((Object)String.valueOf(permissionsUser.getUUID()), (Object)tmp);
        this.savePlayers(tmp3);
    }

    private JSONObject getPlayers() {
        if (this.jsonConfig.containsKey((Object)"players")) {
            return (JSONObject)this.jsonConfig.get((Object)"players");
        }
        return new JSONObject();
    }

    private void savePlayers(JSONObject players) {
        this.jsonConfig.put((Object)"players", (Object)players);
        this.saveFile();
    }

    public void saveGroup(PermissionsGroup permissionsGroup) {
        JSONObject tmp = new JSONObject();
        JSONArray tmp2 = new JSONArray();
        for (Map.Entry<String, Boolean> entry : permissionsGroup.getPermissions(false).entrySet()) {
            if (entry.getValue().booleanValue()) {
                tmp2.add((Object)entry.getKey());
                continue;
            }
            tmp2.add((Object)("-" + entry.getKey()));
        }
        tmp.put((Object)"permissions", (Object)tmp2);
        if (permissionsGroup.getPrefix() != null && !permissionsGroup.getPrefix().isEmpty()) {
            tmp.put((Object)"prefix", (Object)permissionsGroup.getPrefix());
        }
        if (permissionsGroup.getSuffix() != null && !permissionsGroup.getSuffix().isEmpty()) {
            tmp.put((Object)"suffix", (Object)permissionsGroup.getSuffix());
        }
        tmp.put((Object)"default", (Object)permissionsGroup.isDefaultGroup());
        JSONArray tmp4 = new JSONArray();
        for (String inheritance : permissionsGroup.getRawInheritanceGroups()) {
            if (inheritance == null || inheritance.isEmpty()) continue;
            tmp4.add((Object)inheritance.toLowerCase());
        }
        tmp.put((Object)"inheritance", (Object)tmp4);
        JSONObject jSONObject = this.getGroups();
        jSONObject.put((Object)permissionsGroup.getName().toLowerCase(), (Object)tmp);
        this.saveGroups(jSONObject);
    }

    public PermissionsGroup getGroup(String name) {
        JSONObject tmp = this.getGroups();
        if (tmp.containsKey((Object)name.toLowerCase())) {
            try {
                Group group = new Group(this.plugin, name.toLowerCase(), (JSONObject)tmp.get((Object)name.toLowerCase()));
                return group;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String[] getGroupNames() {
        JSONObject tmp = this.getGroups();
        String[] groups = new String[tmp.size()];
        int count = 0;
        for (Object entry : tmp.keySet()) {
            groups[count] = String.valueOf(entry);
            ++count;
        }
        return groups;
    }

    public JSONObject getGroups() {
        if (this.jsonConfig.containsKey((Object)"groups")) {
            return (JSONObject)this.jsonConfig.get((Object)"groups");
        }
        return new JSONObject();
    }

    private void saveGroups(JSONObject groups) {
        this.jsonConfig.put((Object)"groups", (Object)groups);
        this.saveFile();
    }

    protected void saveFile() {
        try (FileWriter file = new FileWriter(this.configFile);){
            file.write(this.jsonConfig.toJSONString());
            file.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isNew() {
        return this.isNew;
    }
}

