/*
 * Decompiled with CFR 0.152.
 */
package com.johnymuffin.jperms.beta.importer;

import com.johnymuffin.jperms.beta.JohnyPerms;
import com.johnymuffin.jperms.beta.objects.Group;
import com.johnymuffin.jperms.beta.util.UUIDFetcher2;
import com.johnymuffin.jperms.beta.util.Util;
import com.johnymuffin.jperms.core.models.PermissionsGroup;
import com.johnymuffin.jperms.core.models.PermissionsUser;
import com.projectposeidon.api.PoseidonUUID;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.PermissionUser;
import ru.tehkode.permissions.bukkit.PermissionsEx;

public class PexImport {
    private JohnyPerms plugin;

    public PexImport(JohnyPerms plugin) {
        this.plugin = plugin;
    }

    public Map<String, UUID> fetchUUIDs() throws Exception {
        this.plugin.logMessage(Level.INFO, "Fetching UUIDs for all users, this could take awhile.");
        PermissionManager permissionManager = PermissionsEx.getPermissionManager();
        int count = 0;
        String[] usernames = new String[permissionManager.getUsers().length];
        JSONArray tmp = new JSONArray();
        for (PermissionUser pexUser : permissionManager.getUsers()) {
            usernames[count] = pexUser.getName();
            ++count;
            tmp.add((Object)pexUser.getName());
        }
        UUIDFetcher2 uuidFetcher = new UUIDFetcher2(Arrays.asList(usernames), true);
        return uuidFetcher.call();
    }

    public void importGroups() {
        PermissionManager permissionManager = PermissionsEx.getPermissionManager();
        for (PermissionGroup pexGroup : permissionManager.getGroups()) {
            Group jpermsGroup = new Group(this.plugin, pexGroup.getName().toLowerCase(), new JSONObject());
            jpermsGroup.setPrefix(pexGroup.getOwnPrefix());
            jpermsGroup.setSuffix(pexGroup.getOwnSuffix());
            for (World world : Bukkit.getServer().getWorlds()) {
                String world2 = world.getName();
                if (!pexGroup.isDefault(world2)) continue;
                jpermsGroup.setIsDefaultGroup(true);
            }
            for (Map.Entry entry : pexGroup.getAllPermissions().entrySet()) {
                for (String permission : (String[])entry.getValue()) {
                    jpermsGroup.addPermission(permission);
                }
            }
            for (Iterator<Object> iterator : pexGroup.getParentGroupsNames()) {
                String[] oldParents = jpermsGroup.getRawInheritanceGroups();
                String[] newParents = new String[oldParents.length + 1];
                int count = 0;
                String[] stringArray = oldParents;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String old;
                    newParents[0] = old = stringArray[i];
                    ++count;
                }
                newParents[count] = ((String)((Object)iterator)).toLowerCase();
                jpermsGroup.setRawInheritanceGroups(newParents);
            }
            jpermsGroup.setSaveStatus(true);
            this.plugin.getGroups().put(pexGroup.getName().toLowerCase(), jpermsGroup);
            this.plugin.logMessage(Level.INFO, "Imported a group called " + jpermsGroup.getName() + " from PEX.");
        }
    }

    public void importPlayers() throws Exception {
        int count = 0;
        PermissionManager permissionManager = PermissionsEx.getPermissionManager();
        Map<String, UUID> uuidMap = this.fetchUUIDs();
        for (PermissionUser pexUser : permissionManager.getUsers()) {
            UUID uuid = Util.getUUIDFromUsername(pexUser.getName());
            if (uuid == null) {
                if (uuidMap.containsKey(pexUser.getName())) {
                    uuid = uuidMap.get(pexUser.getName());
                } else {
                    this.plugin.logMessage(Level.WARNING, "Using Poseidon " + PoseidonUUID.getPlayerUUIDCacheStatus((String)pexUser.getName()).name() + " UUID for player " + pexUser.getName() + ": " + pexUser.getGroups()[0].getName());
                    uuid = PoseidonUUID.getPlayerGracefulUUID((String)pexUser.getName());
                }
            }
            PermissionsUser jPermsUser = this.plugin.getUser(uuid);
            if (pexUser.getGroups().length >= 1) {
                String groupName = pexUser.getGroups()[0].getName();
                if (this.plugin.getGroups().containsKey(groupName.toLowerCase())) {
                    PermissionsGroup group = this.plugin.getGroups().get(groupName.toLowerCase());
                    jPermsUser.setGroup(group);
                } else {
                    this.plugin.logMessage(Level.WARNING, "Failed to add the group called " + groupName.toLowerCase() + " to " + pexUser.getName() + " as it couldn't be found.");
                }
            } else {
                this.plugin.logMessage(Level.WARNING, "Failed to find any groups for " + pexUser.getName() + ", assuming default group.");
            }
            jPermsUser.setSaveStatus(true);
        }
        if (count > 0) {
            this.plugin.logMessage(Level.WARNING, "Failed to import " + count + " players as UUID couldn't be found.");
        }
    }
}

