/*
 * Decompiled with CFR 0.152.
 */
package com.johnymuffin.jperms.beta.objects;

import com.johnymuffin.jperms.beta.JohnyPerms;
import com.johnymuffin.jperms.beta.util.PermissionNode;
import com.johnymuffin.jperms.beta.util.Util;
import com.johnymuffin.jperms.core.models.PermissionsAesthetics;
import com.johnymuffin.jperms.core.models.PermissionsGroup;
import com.johnymuffin.jperms.core.models.PermissionsObject;
import com.johnymuffin.jperms.core.models.PermissionsUser;
import com.johnymuffin.jperms.core.models.SavableObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Group
implements PermissionsGroup,
PermissionsObject,
PermissionsAesthetics,
SavableObject {
    private JohnyPerms plugin;
    private String groupName;
    private String prefix;
    private String suffix;
    private boolean defaultGroup;
    private String[] inheritance;
    private HashMap<String, Boolean> permissions = new HashMap();
    private boolean isModified = false;

    public Group(JohnyPerms plugin, String groupName, JSONObject groupData) {
        this.plugin = plugin;
        this.groupName = groupName;
        if (groupData.containsKey((Object)"prefix")) {
            this.prefix = String.valueOf(groupData.get((Object)"prefix"));
        }
        if (groupData.containsKey((Object)"suffix")) {
            this.suffix = String.valueOf(groupData.get((Object)"suffix"));
        }
        this.defaultGroup = Boolean.valueOf(String.valueOf(groupData.getOrDefault((Object)"default", (Object)false)));
        if (groupData.containsKey((Object)"inheritance")) {
            JSONArray inheritanceRaw = (JSONArray)groupData.get((Object)"inheritance");
            this.inheritance = new String[inheritanceRaw.size()];
            for (int i = 0; i < inheritanceRaw.size(); ++i) {
                this.inheritance[i] = String.valueOf(inheritanceRaw.get(i));
            }
        } else {
            this.inheritance = new String[0];
        }
        this.permissions = Util.getPermissions((JSONArray)groupData.getOrDefault((Object)"permissions", (Object)new JSONArray()));
    }

    @Override
    public String getName() {
        return this.groupName;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
        this.isModified = true;
    }

    @Override
    public void setSuffix(String suffix) {
        this.suffix = suffix;
        this.isModified = true;
    }

    @Override
    public PermissionsGroup[] getInheritanceGroups() {
        int count = 0;
        for (int i = 0; i < this.inheritance.length; ++i) {
            if (!this.plugin.getGroups().containsKey(this.inheritance[i])) continue;
            ++count;
        }
        PermissionsGroup[] temp = new PermissionsGroup[count];
        int insert = 0;
        for (int i = 0; i < this.inheritance.length; ++i) {
            if (this.plugin.getGroups().containsKey(this.inheritance[i])) {
                temp[insert] = this.plugin.getGroups().get(this.inheritance[i]);
                ++insert;
                continue;
            }
            this.plugin.logMessage(Level.WARNING, "A invalid inheritance group called " + this.inheritance[i] + " is in the config for " + this.groupName);
        }
        return temp;
    }

    @Override
    public String[] getRawInheritanceGroups() {
        return (String[])this.inheritance.clone();
    }

    @Override
    public void setRawInheritanceGroups(String[] groups) {
        this.inheritance = groups;
        this.isModified = true;
    }

    @Override
    public PermissionsUser[] getUsers() {
        int count = 0;
        for (UUID uuid : this.plugin.getUsers().keySet()) {
            if (this.plugin.getUsers().get(uuid).getGroup() != this) continue;
            ++count;
        }
        PermissionsUser[] temp = new PermissionsUser[count];
        int count2 = 0;
        for (UUID uuid : this.plugin.getUsers().keySet()) {
            if (this.plugin.getUsers().get(uuid).getGroup() != this) continue;
            temp[count2] = this.plugin.getUsers().get(uuid);
            ++count2;
        }
        return temp;
    }

    @Override
    public HashMap<String, Boolean> getPermissions() {
        return this.getPermissions(true);
    }

    @Override
    public HashMap<String, Boolean> getPermissions(boolean deepSearch) {
        if (!deepSearch) {
            return (HashMap)this.permissions.clone();
        }
        HashMap<String, Boolean> temp = new HashMap<String, Boolean>();
        for (PermissionsGroup group : this.getInheritanceGroups()) {
            HashMap<String, Boolean> groupPerms = group.getPermissions(true);
            for (String permission : groupPerms.keySet()) {
                temp.put(permission, groupPerms.get(permission));
            }
        }
        for (String string : this.permissions.keySet()) {
            temp.put(string, this.permissions.get(string));
        }
        for (Map.Entry entry : this.plugin.getAllPluginPerms().entrySet()) {
            if (!Util.hasPermissionOnMap((String)entry.getKey(), this.permissions).booleanValue()) continue;
            temp.put((String)entry.getKey(), (Boolean)entry.getValue());
        }
        return temp;
    }

    @Override
    public boolean isDefaultGroup() {
        return this.defaultGroup;
    }

    @Override
    public void setIsDefaultGroup(boolean value) {
        this.defaultGroup = value;
        this.isModified = true;
    }

    @Override
    public void addPermission(String permission, boolean value) {
        this.permissions.put(permission, value);
        this.isModified = true;
    }

    @Override
    public void addPermission(String permission) {
        PermissionNode permissionNode = Util.convertPermission(permission);
        this.addPermission(permissionNode.getPermission(), permissionNode.isValue());
    }

    @Override
    public boolean removePermission(String permission, boolean value) {
        boolean removal = this.permissions.remove(permission, value);
        this.isModified = true;
        return removal;
    }

    @Override
    public boolean removePermission(String permission) {
        PermissionNode permissionNode = Util.convertPermission(permission);
        return this.removePermission(permissionNode.getPermission(), permissionNode.isValue());
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.hasPermission(permission, true);
    }

    @Override
    public boolean hasPermission(String permission, boolean deepSearch) {
        return Util.hasPermissionOnMap(permission, this.getPermissions(deepSearch));
    }

    @Override
    public void saveObject() {
        this.isModified = true;
    }

    @Override
    public boolean isSaving() {
        return this.isModified;
    }

    @Override
    public void setSaveStatus(boolean value) {
        this.isModified = value;
    }
}

