/*
 * Decompiled with CFR 0.152.
 */
package com.johnymuffin.jperms.beta.objects;

import com.johnymuffin.jperms.beta.JohnyPerms;
import com.johnymuffin.jperms.beta.util.PermissionNode;
import com.johnymuffin.jperms.beta.util.Util;
import com.johnymuffin.jperms.core.models.PermissionsAesthetics;
import com.johnymuffin.jperms.core.models.PermissionsGroup;
import com.johnymuffin.jperms.core.models.PermissionsObject;
import com.johnymuffin.jperms.core.models.PermissionsUser;
import com.johnymuffin.jperms.core.models.SavableObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class User
implements PermissionsUser,
PermissionsObject,
PermissionsAesthetics,
SavableObject {
    private UUID uuid;
    private String lastKnownUsername;
    private HashMap<String, Boolean> permissions = new HashMap();
    private JohnyPerms plugin;
    private PermissionsGroup group;
    private boolean isModified = false;
    private boolean isNew;

    public User(JohnyPerms plugin, JSONObject playerData, UUID uuid, boolean isNew) {
        this.plugin = plugin;
        this.isNew = isNew;
        this.permissions = Util.getPermissions((JSONArray)playerData.getOrDefault((Object)"permissions", (Object)new JSONArray()));
        this.uuid = uuid;
        String rawGroupName = String.valueOf(playerData.getOrDefault((Object)"group", (Object)plugin.getDefaultGroup().getName()));
        this.lastKnownUsername = String.valueOf(playerData.get((Object)"lastKnownUsername"));
        this.group = plugin.getGroups().containsKey(rawGroupName) ? plugin.getGroups().get(rawGroupName) : plugin.getDefaultGroup();
    }

    public User(JohnyPerms plugin, UUID uuid) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.isNew = true;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public HashMap<String, Boolean> getPermissions() {
        return this.getPermissions(true);
    }

    @Override
    public HashMap<String, Boolean> getPermissions(boolean deepSearch) {
        if (!deepSearch) {
            return (HashMap)this.permissions.clone();
        }
        HashMap temp = (HashMap)this.getGroup().getPermissions().clone();
        for (String string : this.permissions.keySet()) {
            temp.put(string, this.permissions.get(string));
        }
        for (Map.Entry entry : this.plugin.getAllPluginPerms().entrySet()) {
            if (!Util.hasPermissionOnMap((String)entry.getKey(), this.permissions).booleanValue()) continue;
            temp.put(entry.getKey(), entry.getValue());
        }
        return temp;
    }

    @Override
    public PermissionsGroup getGroup() {
        if (this.group == null) {
            return this.plugin.getDefaultGroup();
        }
        return this.group;
    }

    @Override
    public void setGroup(PermissionsGroup group) {
        this.group = group;
        this.isModified = true;
    }

    @Override
    public boolean hasPermission(String permission) {
        HashMap<String, Boolean> temp = this.getPermissions();
        if (temp.containsKey(permission)) {
            return temp.get(permission);
        }
        return false;
    }

    @Override
    public boolean hasPermission(String permission, boolean deepSearch) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public boolean hasPermissionSomehow(String permission, boolean deepSearch) {
        return Util.hasPermissionOnMap(permission, this.getPermissions(deepSearch));
    }

    @Override
    public void addPermission(String permission, boolean value) {
        this.permissions.put(permission, value);
        this.isModified = true;
    }

    @Override
    public void addPermission(String permission) {
        PermissionNode permissionNode = Util.convertPermission(permission);
        this.addPermission(permissionNode.getPermission(), permissionNode.isValue());
    }

    @Override
    public boolean removePermission(String permission, boolean value) {
        boolean removed = this.permissions.remove(permission, value);
        this.isModified = true;
        return removed;
    }

    @Override
    public boolean removePermission(String permission) {
        PermissionNode permissionNode = Util.convertPermission(permission);
        return this.removePermission(permissionNode.getPermission(), permissionNode.isValue());
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public String getSuffix() {
        return null;
    }

    @Override
    public void setPrefix(String prefix) {
    }

    @Override
    public void setSuffix(String suffix) {
    }

    @Override
    public void saveObject() {
        this.isModified = true;
    }

    @Override
    public boolean isSaving() {
        return this.isModified;
    }

    @Override
    public void setSaveStatus(boolean value) {
        this.isModified = value;
    }

    @Override
    public String getLastKnownUsername() {
        return this.lastKnownUsername;
    }

    @Override
    public void setLastKnownUsername(String lastKnownUsername) {
        if (this.getGroup() == this.plugin.getDefaultGroup()) {
            this.lastKnownUsername = lastKnownUsername;
            return;
        }
        if (this.getLastKnownUsername() != null && this.getLastKnownUsername().equals(lastKnownUsername)) {
            return;
        }
        this.lastKnownUsername = lastKnownUsername;
        this.isModified = true;
    }
}

