/*
 * Decompiled with CFR 0.152.
 */
package com.johnymuffin.jperms.beta.util;

import com.johnymuffin.jperms.beta.util.PermissionNode;
import com.projectposeidon.api.PoseidonUUID;
import com.projectposeidon.api.UUIDType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.json.simple.JSONArray;

public class Util {
    private static Pattern p = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$");

    public static HashMap<String, Boolean> getPermissions(JSONArray permissions) {
        HashMap<String, Boolean> temp = new HashMap<String, Boolean>();
        for (int i = 0; i < permissions.size(); ++i) {
            if (permissions == null) continue;
            PermissionNode node = Util.convertPermission(String.valueOf(permissions.get(i)));
            temp.put(node.getPermission(), node.isValue());
        }
        return temp;
    }

    public static PermissionNode convertPermission(String permission) {
        if (permission.substring(0, 1).equalsIgnoreCase("-")) {
            permission = permission.substring(1);
            return new PermissionNode(permission, false);
        }
        return new PermissionNode(permission, true);
    }

    public static Player getPlayerFromString(String name) {
        List players = Bukkit.matchPlayer((String)name);
        if (players.size() == 1) {
            return (Player)players.get(0);
        }
        return null;
    }

    public static UUID getUUIDFromUsername(String name) {
        Player player = Util.getPlayerFromString(name);
        if (player != null) {
            return player.getUniqueId();
        }
        UUIDType uuidType = PoseidonUUID.getPlayerUUIDCacheStatus((String)name);
        switch (uuidType) {
            case ONLINE: {
                return PoseidonUUID.getPlayerUUIDFromCache((String)name, (boolean)true);
            }
            case OFFLINE: {
                return PoseidonUUID.getPlayerUUIDFromCache((String)name, (boolean)false);
            }
        }
        if (p.matcher(name).matches()) {
            try {
                return UUID.fromString(name);
            }
            catch (IllegalArgumentException exception) {
                return null;
            }
        }
        return null;
    }

    public static Boolean hasPermissionOnMap(String permission, Map<String, Boolean> map) {
        int endIndex;
        String node = permission;
        while ((endIndex = node.lastIndexOf(46)) != -1) {
            Boolean b;
            if ((node = node.substring(0, endIndex)).isEmpty() || (b = map.get(node + ".*")) == null) continue;
            return b;
        }
        Boolean b = map.get("'*'");
        if (b != null) {
            return b;
        }
        b = map.get("*");
        if (b != null) {
            return b;
        }
        return false;
    }
}

